/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.obj.compras;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.ats.modelo.obj.Comprobante;
import ec.gob.sri.dimm.data.impl.UtilCatalogosATS;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ComprobanteModificado
extends Comprobante {
    private static final long serialVersionUID = -1287447990656830695L;
    public static final String C_TIPO_COMPROBANTE = "tipoComprobante";
    @NotNull(message="Debe seleccionar el tipo de Documento Modificado")
    private String tipoComprobante;
    private String descripcionTipoComprobante;

    @Override
    public ComprobanteModificado crearCopiaEdicion() {
        ComprobanteModificado copia = new ComprobanteModificado();
        copia.setEstablecimiento(super.getEstablecimiento());
        copia.setPuntoEmision(super.getPuntoEmision());
        copia.setSecuencial(super.getSecuencial());
        copia.setNumAutorizacion(super.getNumAutorizacion());
        copia.setFechaEmision(super.getFechaEmision());
        copia.setTipoComprobante(this.tipoComprobante);
        copia.setDescripcionTipoComprobante(this.descripcionTipoComprobante);
        copia.setPropietario(this.propietario);
        return copia;
    }

    @Override
    public void actualizarInformacion(Comprobante copiaEdicion) {
        ComprobanteModificado comprobanteModificado = (ComprobanteModificado)copiaEdicion;
        this.setTipoComprobante(comprobanteModificado.getTipoComprobante());
        this.setDescripcionTipoComprobante(comprobanteModificado.getDescripcionTipoComprobante());
        super.actualizarInformacion(copiaEdicion);
    }

    @Override
    protected ResultadoValidacion validarObjeto() {
        ResultadoValidacion resultado = new ResultadoValidacion();
        if (this.validarPattern("\\d{3}(?<!000)", this.getEstablecimiento(), "El valor Establecimiento debe ser solo n\u00fameros. Diferente de cero. 3 d\u00edgitos. ", resultado).esEstadoFallido()) {
            return resultado;
        }
        if (this.validarPattern("\\d{3}(?<!000)", this.getPuntoEmision(), "El valor Punto de emisi\u00f3n debe ser solo n\u00fameros. Diferente de cero. 3 d\u00edgitos. ", resultado).esEstadoFallido()) {
            return resultado;
        }
        if (this.validarPattern("\\d{1,9}", this.getSecuencial(), "El valor Secuencial debe ser solo n\u00fameros. Diferente de cero.  M\u00ednimo 1 d\u00edgito, m\u00e1ximo 9. ", resultado).esEstadoFallido()) {
            return resultado;
        }
        if (this.validarPattern("\\d{3,49}", this.getNumAutorizacion(), "El valor Autorizaci\u00f3n debe ser solo n\u00fameros. Diferente de cero. 3 d\u00edgitos. ", resultado).esEstadoFallido()) {
            return resultado;
        }
        if (this.validarSecuencial(resultado).esEstadoFallido()) {
            return resultado;
        }
        if (this.validarNumAutorizacion(resultado).esEstadoFallido()) {
            return resultado;
        }
        return resultado.pasarValidacion();
    }

    @Override
    public Object importar(Element elemento, Map<String, Element> mapaData) {
        NodeList valorList = elemento.getElementsByTagName("estabModificado");
        Element eValor = (Element)valorList.item(0);
        this.setEstablecimiento(eValor.getTextContent());
        valorList = elemento.getElementsByTagName("ptoEmiModificado");
        eValor = (Element)valorList.item(0);
        this.setPuntoEmision(eValor.getTextContent());
        valorList = elemento.getElementsByTagName("secModificado");
        eValor = (Element)valorList.item(0);
        this.setSecuencial(eValor.getTextContent());
        valorList = elemento.getElementsByTagName("autModificado");
        eValor = (Element)valorList.item(0);
        this.setNumAutorizacion(eValor.getTextContent());
        valorList = elemento.getElementsByTagName("docModificado");
        eValor = (Element)valorList.item(0);
        this.tipoComprobante = eValor.getTextContent().trim();
        this.descripcionTipoComprobante = String.valueOf(this.getTipoComprobante()) + "-" + UtilCatalogosATS.crearInstancia().obtenerDescripcionComprobante(this.getTipoComprobante());
        return this;
    }

    public String getTipoComprobante() {
        return this.tipoComprobante;
    }

    public String getDescripcionTipoComprobante() {
        return this.descripcionTipoComprobante;
    }

    public void setTipoComprobante(String tipoComprobante) {
        String oldValue = this.tipoComprobante;
        this.tipoComprobante = StringUtil.isNullOrEmpty((String)tipoComprobante) ? tipoComprobante : tipoComprobante.toUpperCase();
        this.firePropertyChange(C_TIPO_COMPROBANTE, oldValue, this.tipoComprobante);
    }

    public void setDescripcionTipoComprobante(String descripcionTipoComprobante) {
        this.descripcionTipoComprobante = descripcionTipoComprobante;
    }

    public void reestablecer() {
        ComprobanteModificado copia = new ComprobanteModificado();
        this.actualizarInformacion(copia);
    }
}

